IDBase equ 0

.model tiny

include v25.inc

.code
    org 100h
start:
    jmp _start

    counter dw 0
    p2data  db 0

_start:
    push cs
    pop ds
    mov dx, offset cs:hook
    mov al, 41h   ; timer hook vector
    mov ah, 25h   ; set interrupt vector
    int 21h

    mov ah, 31h   ; terminate and stay resident
    int 21h

hook:
    push ax
    push bx
    push cx
    push dx
    push di
    push si
    push bp
    push ds
    push es

    push cs
    pop ds

    inc counter
    cmp counter, 250
    jbe @F

    xor p2data, 80h
    mov counter, 0

    mov ah, 0   ; get seg of SFR's in ES (config)
    int 40h

    mov al, p2data
    mov es:P2, al
@@:

    pop es
    pop ds
    pop bp
    pop si
    pop di
    pop dx
    pop cx
    pop bx
    pop ax

    iret

end start
