/* Linker script for 68HC12 object file (ld -r).  */
OUTPUT_FORMAT("elf32-m68hc12", "elf32-m68hc12",
	      "elf32-m68hc12")
OUTPUT_ARCH(m68hc12)
ENTRY(_start)
SEARCH_DIR(C:/68hc11/gcc/lib/gcc-lib/m6811-elf/2.95.3/m68hc12)


/*
 *  Use the MEMORY command to define the types of memory available on
 *  the target system.  This is how you describe the system's memory
 *  map to the linker.
 *  
 *  On the 68hc912b32, the memory map looks like this:
 *
 *  Address range         Memory type
 *  -------------         -----------
 *      0 - $01ff         I/O ports
 *  $0800 - $0bff         static RAM
 *  $0d00 - $0fff         EEPROM
 *  $8000 - $ff7f         flash EEPROM, less vectors
 *  $ff80 - $ffff	  flash EEPROM vector area
 *
 *  Note that some 68hc12 development boards may include a firmware downloader
 *  in their 68hc12 chip that overrides the normal memory map.  For example,
 *  the Technological Arts Adapt912b32 board contains a downloader that takes
 *  control of the normal vector area.  In this case, the TA downloader moves
 *  the vector area to $f780 - $f7ff.
 */

MEMORY
{
  IOPORTS (!x)    : org = 0x0000, l = 0x0200
  RAM     (wx)    : org = 0x0800, l = 0x0400
  EEPROM  (!i)    : org = 0x0d00, l = 0x0300
  ROM     (rx)    : org = 0x8000, l = 0x7f80
  VECTORS (rx)    : org = 0xf780, l = 0x0080	/* special for Adapt912b32 board */
}

PROVIDE (_stack = 0x0c00);



SECTIONS
{
/*
 *  Declare the I/O ports section.
 *
 *  On the 68hc912b32, this starts at address 0x0000.
 */

  IOPORTS  :
  {
  }  >IOPORTS



/*
 *  Declare the EEPROM section.
 *
 *  On the 68hc912b32, this starts at address 0x0d00.
 */

  EEPROM   :
  {
  PROVIDE (_start_of_eeprom = .);
  }  >EEPROM



/*
 *  Declare the VECTORS section.
 *
 *  On the 68hc912b32, this starts at 0xff80.
 */

  VECTORS  :
  {
  PROVIDE (_start_of_vectors = .);
  vectors.o
  }  >VECTORS



/*
 *  Declare the start of general-purpose RAM.
 *  
 *  This is where most variables and arrays will appear.  On the 68hc912b32,
 *  this is normally at $800.
 */

  RAM   :
  {
    PROVIDE (_start_of_ram = .);
    *(.sdata) 
    *(.sbss) 
    *(.scommon) 
    *(.dynbss)
    PROVIDE (_start_of_bss = .);
    *(.bss)
    PROVIDE (_end_of_bss = .);
    *(COMMON)
    PROVIDE (_end_of_ram = .);
  }  >RAM 



/*
 *  Start of text section.
 *
 *  The .text section typically holds ROMmed code.  _start usually
 *  appears at the beginning of this section.  On the 68hc912b32,
 *  this is normally at $8000.
 */

  ROM  :
  {
    PROVIDE (_start_of_rom = .);
    *(.text) 
    *(.gnu.warning)
    PROVIDE (_start_of_rodata = .);
    *(.rodata)
    PROVIDE (_end_of_rodata = .);
    PROVIDE (_start_of_rodata1 = .);
    *(.rodata1)
    PROVIDE (_end_of_rodata1 = .);
    *(.stab) 
    *(.stabstr) 
    *(.stab.excl) 
    *(.stab.exclstr) 
    *(.stab.index) 
    *(.stab.indexstr) 
    *(.comment)
    _end_of_rom1 = .;
    PROVIDE (_start_of_init = .);
  } >ROM



  .init : AT (_end_of_rom1)
  {
    _start_of_data = .;
    PROVIDE (_start_of_data = .);
    *(.data)
    *(.data1)
    _end_of_data = .;
    PROVIDE (_end_of_data = .);
  } >RAM



  /* DWARF debug sections.
     Symbols in the DWARF debugging sections are relative to the beginning
     of the section so we begin them at 0.
     Treatment of DWARF debug section must be at end of the linker
     script to avoid problems when there are undefined symbols. It's necessary
     to avoid that the DWARF section is relocated before such undefined
     symbols are found.  */
  /* DWARF 1 */
  .debug	 0 : { *(.debug) }
  .line		 . : { *(.line) }
  /* GNU DWARF 1 extensions */
  .debug_srcinfo . : { *(.debug_srcinfo) }
  .debug_sfnames . : { *(.debug_sfnames) }
  /* DWARF 1.1 and DWARF 2 */
  .debug_aranges  . : { *(.debug_aranges) }
  .debug_pubnames . : { *(.debug_pubnames) }
  /* DWARF 2 */
  .debug_info     . : { *(.debug_info) *(.gnu.linkonce.wi.*) }
  .debug_abbrev   . : { *(.debug_abbrev) }
  .debug_line     . : { *(.debug_line) }
  .debug_frame    . : { *(.debug_frame) }
  .debug_str      . : { *(.debug_str) }
  .debug_loc      . : { *(.debug_loc) }
  .debug_macinfo  . : { *(.debug_macinfo) }
}
